## Private VLANs (PVLANs): Traffic Isolation Within a VLAN

---

### Background and Need

- **ISP and Enterprise Use Case**
    
    - Multiple client devices and servers often share the same DMZ or VLAN.
    - Increasing security demands require traffic isolation, even on the same Layer 3 segment.
- **Traditional Solution**
    
    - Assign one VLAN and subnet per customer/device type.
    - Use Layer 3 devices for inter-VLAN routing and access control.
- **Challenges with Traditional Solution**
    
    - High interface count needed on network devices.
    - Wasted address space due to numerous small subnets.
    - Increased management complexity from multiple ACLs and VLANs.

---

### Introducing Private VLANs (PVLANs)

- **Purpose**
    - Provides Layer 2 isolation between ports within the same VLAN.
    - Eliminates the need for separate VLANs/subnets per customer or device type.
    - Simplifies traffic management and conserves IP address space.

#### PVLAN Structure

- **Primary VLAN**
    - The main VLAN that all devices belong to; hosts the Layer 3 subnet.
- **Secondary VLANs**
    - **Isolated VLANs:** Ports can only communicate with promiscuous ports.
    - **Community VLANs:** Ports can communicate with each other and promiscuous ports, but not with other communities or isolated ports.
- **Promiscuous Ports**
    - Can communicate with all ports within the primary VLAN.
    - Typically connect to routers, firewalls, or gateways.
- **Port Types**
    - **Isolated Port:** Only communicates with promiscuous ports.
    - **Community Port:** Communicates with other community members and promiscuous ports.
    - **Promiscuous Port:** Communicates with all other port types.

---

### PVLAN Operations and Rules

- **Communication Rules**
    
    - Isolated ports: Only to promiscuous.
    - Community ports: With their own community and promiscuous.
    - Promiscuous ports: With all.
- **Extending PVLANs Across Switches**
    
    - Use trunk ports to carry primary, isolated, and community VLANs.
    - 802.1Q encapsulation is required.
    - PVLANs must be configured manually on all switches (VTP does **not** support PVLANs; set VTP mode to transparent).

---

### Configuration Example

**Topology Example:**

- Server (isolated): VLAN 110 (secondary isolated)
- Computers (community): VLAN 120 (secondary community)
- Gateway (promiscuous): VLAN 100 (primary)
- Trunk: Fa0/8

**Sample Configuration Steps:**

1. **Set VTP Mode**
    - `vtp mode transparent`
2. **Create VLANs**
    - `vlan 110` → `private-vlan isolated`
    - `vlan 120` → `private-vlan community`
    - `vlan 100` → `private-vlan primary`
    - `private-vlan association 110,120`
3. **Assign Ports**
    - Isolated port:
        - `interface Fa0/4`
        - `switchport mode private-vlan host`
        - `switchport private-vlan host-association 100,110`
    - Community ports:
        - `interface range Fa0/2 - 3`
        - `switchport mode private-vlan host`
        - `switchport private-vlan host-association 100,120`
    - Promiscuous port:
        - `interface Fa0/1`
        - `switchport mode private-vlan promiscuous`
        - `switchport private-vlan mapping 100,110,120`
    - Trunk port:
        - `interface Fa0/8`
        - `switchport mode trunk`
        - `switchport trunk encapsulation dot1q`

---

### Verification Commands

- **Check PVLAN Types**
    - `show vlan private-vlan type`
        - Lists VLAN numbers and their type (primary, isolated, community).
- **Check PVLAN Associations**
    - `show vlan private-vlan`
        - Shows mapping of primary to secondary VLANs and associated ports.
- **Check Port Configuration**
    - `show interfaces [if_name] switchport`
        - Displays switchport mode and PVLAN details.

---

### Key Points

- PVLANs provide efficient Layer 2 isolation within a single VLAN, reducing complexity and conserving address space.
- Use cases: ISPs, DMZs, large enterprises with multiple client types on shared segments.
- Requires careful configuration and manual setup on each switch (VTP not supported).
- Supports scalable, flexible security policies without the need for excessive VLANs and subnets.